/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public final class BufferUtils {
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;

    private BufferUtils() {
    }

    public static ByteBuffer allocateByteBuffer(int bytes) {
        return ByteBuffer.allocateDirect(bytes);
    }

    public static IntBuffer allocateIntBuffer() {
        return ByteBuffer.allocateDirect(4).asIntBuffer();
    }

    public static LongBuffer allocateLongBuffer() {
        return ByteBuffer.allocateDirect(8).asLongBuffer();
    }

    public static ByteBuffer slice(ByteBuffer buffer, int offset, int length) {
        int oldPosition = buffer.position();
        int oldLimit = buffer.limit();
        buffer.position(offset);
        buffer.limit(offset + length);
        ByteBuffer slice = buffer.slice();
        buffer.position(oldPosition);
        buffer.limit(oldLimit);
        return slice;
    }
}

